// ==UserScript==
// @name         5ch オリジナルポップアップ用 （aタグをspan要素に書き換え）
// @namespace    http://tampermonkey.net/
// @version      1.0
// @description  >>123や>123を含むaタグをspanでくるむ（動的対応）
// @match        *://*.5ch.net/*
// @grant        none
// @run-at       document-end
// ==/UserScript==

(function() {
    function resolveHref(href) {
        const a = document.createElement('a');
        a.href = href;
        return a.href;
    }

    function replaceReplyLink(a) {
        if (!a || !a.textContent) return;
        if (/^>>\d+$/.test(a.textContent.trim())) {
            const span = document.createElement('span');
            span.className = 'custom_reply';
            span.textContent = a.textContent;

            let href = a.getAttribute('href');
            if (href) {
                span.setAttribute('data-href', resolveHref(href));
            }

            a.parentNode.replaceChild(span, a);
        }
    }

    // 初期ロード時にあるものを置き換え
    document.querySelectorAll('a.reply_link').forEach(replaceReplyLink);

    // MutationObserverで動的追加も監視
    const observer = new MutationObserver(mutations => {
        mutations.forEach(mutation => {
            mutation.addedNodes.forEach(node => {
                if (node.nodeType !== 1) return; // Element以外は無視

                // 追加された要素自身がa.reply_linkなら処理
                if (node.matches && node.matches('a.reply_link')) {
                    replaceReplyLink(node);
                }

                // 子孫にa.reply_linkがあれば処理
                node.querySelectorAll && node.querySelectorAll('a.reply_link').forEach(replaceReplyLink);
            });
        });
    });

    observer.observe(document.body, { childList: true, subtree: true });
})();
